<?php
define('BOT_TOKEN', '8662791148:AAE4hu_n3WqEnbMluGmpeosI8C5i1is8pgs');
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');
define('TARGET_URL', 'https://t.ly/tgozelpromo');
define('GIF_URL', 'https://r.resimlink.com/QHus-k.gif');
define('STATE_FILE', __DIR__ . '/state.json');

$content = file_get_contents('php://input');
file_put_contents(__DIR__ . '/log.txt', $content . PHP_EOL, FILE_APPEND);
$update = json_decode($content, true);

if (!$update) { http_response_code(200); exit(); }

if (isset($update['message']['chat']['id'])) {
    $chat_id = (string)$update['message']['chat']['id'];
    $text = trim($update['message']['text'] ?? '');

    $file = __DIR__ . '/users.txt';
    if (!file_exists($file)) file_put_contents($file, '');
    $chat_ids = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (!in_array($chat_id, $chat_ids, true)) {
        file_put_contents($file, $chat_id . PHP_EOL, FILE_APPEND);
    }

    $state = getUserState($chat_id);

    if ($text === '/start' || $text === '🚀 BAŞLAT') {
        setUserState($chat_id, 'main');
        sendMainMenu($chat_id);
        sendReplyKeyboard($chat_id, 'main');
        http_response_code(200); exit();
    }

    if ($text === '/giris' || $text === '🏛 NoWin Giriş') {
        setUserState($chat_id, 'main');
        sendNoWinEntry($chat_id);
        sendReplyKeyboard($chat_id, 'main');
        http_response_code(200); exit();
    }

    if ($text === '/istatistik') {
        sendStats($chat_id);
        http_response_code(200); exit();
    }

    if ($text === '🎁 Bonuslar') {
        setUserState($chat_id, 'bonus');
        sendMessage($chat_id, "🎁 <b>Bonuslar Menüsü</b>\nAşağıdan bir bonus seçin:", null, true);
        sendReplyKeyboard($chat_id, 'bonus');
        http_response_code(200); exit();
    }

    if ($text === '⬅️ Geri') {
        setUserState($chat_id, 'main');
        sendMainMenu($chat_id);
        sendReplyKeyboard($chat_id, 'main');
        http_response_code(200); exit();
    }

    $bonusMap = [
        '🎰 İlk Yatırım Bonusu' => "🎰 <b>Yatırım Bonusu: Casino</b>\n\nİlk casino yatırmanızda <b>%150 + 60 FS</b> bonusu alın.",
        '🧩 Görev Bonusu'        => "🧩 <b>Görev Bonusu</b>\n\nGörevlerle <b>Haftalık Bonusları Aç</b>.",
        '📅 Günlük Bonus'        => "📅 <b>Günlük Bonus</b>\n\n<b>Günlük Reload Bonusları</b>.",
        '🏟 Spor Bonusu'         => "🏟 <b>Spor Bonusu</b>\n\nSpor Hoş Geldin Bonusu: <b>Yatırıma %150</b>.",
        '🎡 Günlük Çark'         => "🎡 <b>Günlük Çark</b>\n\n<b>Günlük Bonus Çarkı</b>.",
        '📉 Haftalık Kayıp Bonusu' => "📉 <b>Haftalık Kayıp Bonusu</b>\n\nSlot ve Canlı Casinoda Haftalık Kayıp Bonosu <b>%10</b>."
    ];

    if (isset($bonusMap[$text])) {
        setUserState($chat_id, 'bonus');
        $msg = $bonusMap[$text] . "\n\n🔎 Detaylar için sitemizi ziyaret edebilirsiniz:\n" .
                "<a href=\"".TARGET_URL."\">".TARGET_URL."</a>";
        sendMessage($chat_id, $msg, buildInlineKeyboardSingle(), true);
        sendReplyKeyboard($chat_id, 'bonus');
        http_response_code(200); exit();
    }

    if ($state === 'bonus') {
        sendMessage($chat_id, "🎁 Bonuslar için aşağıdaki seçeneklerden birini seçebilirsin.\n⬅️ Geri ile ana menüye dönebilirsin.", null, true);
        sendReplyKeyboard($chat_id, 'bonus');
    } else {
        sendMessage($chat_id, "🎯 Komutlar:\n/start\n/giris\n/istatistik\n\n⬇️ Alttaki menüyü kullanabilirsin.", null, true);
        sendReplyKeyboard($chat_id, 'main');
    }
    http_response_code(200); exit();
}

function buildInlineKeyboardSingle() {
    return ['inline_keyboard' => [[['text' => '🏛️ NOWIN GİRİŞ', 'url' => TARGET_URL], ['text' => '🎁 BONUSLARI GÖR', 'url' => TARGET_URL]]]];
}

function buildReplyKeyboard($mode = 'main') {
    if ($mode === 'bonus') {
        return ['keyboard' => [[['text' => '🎰 İlk Yatırım Bonusu'], ['text' => '🧩 Görev Bonusu']], [['text' => '📅 Günlük Bonus'], ['text' => '🏟 Spor Bonusu']], [['text' => '🎡 Günlük Çark'], ['text' => '📉 Haftalık Kayıp Bonusu']], [['text' => '⬅️ Geri']]], 'resize_keyboard' => true, 'one_time_keyboard' => false];
    }
    return ['keyboard' => [[['text' => '🚀 BAŞLAT']], [['text' => '🏛 NoWin Giriş'], ['text' => '🎁 Bonuslar']]], 'resize_keyboard' => true, 'one_time_keyboard' => false];
}

function sendReplyKeyboard($chat_id, $mode = 'main') {
    $data = ['chat_id' => $chat_id, 'text' => '⬇️ Menü', 'reply_markup' => json_encode(buildReplyKeyboard($mode), JSON_UNESCAPED_UNICODE)];
    file_get_contents(API_URL . 'sendMessage?' . http_build_query($data));
}

function sendMainMenu($chat_id) {
    $caption = "🏆 <b>NoWin | Premium Casino & Canlı Bahis</b>\n━━━━━━━━━━━━━━━━━━\n\n🛡️ <b>Lisanslı • Güvenli • Hızlı</b>\n\n🔥 <b>Avantajlar</b>\n• Yüksek RTP oranları\n• Anlık promosyonlar & özel bonuslar\n• Yatırımsız deneme bonusları / free spin\n• Akıcı ve hızlı bahis deneyimi\n\n⚡️ <b>Güncel giriş:</b>\n<a href=\"".TARGET_URL."\">".TARGET_URL."</a>\n\n👇🏻 <b>Aşağıdan menüden seçim yapabilirsin.</b>";
    sendGifMessage($chat_id, GIF_URL, $caption, buildInlineKeyboardSingle());
}

function sendNoWinEntry($chat_id) {
    $caption = "🏛️ <b>NoWin Güncel Giriş</b>\n━━━━━━━━━━━━━━━━━━\n\n✅ Hızlı erişim • ✅ Güvenli bağlantı\n\n👇🏻 Giriş için butona tıkla:";
    sendGifMessage($chat_id, GIF_URL, $caption, buildInlineKeyboardSingle());
}

function sendStats($chat_id) {
    $file = __DIR__ . '/users.txt';
    $count = file_exists($file) ? count(file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES)) : 0;
    sendMessage($chat_id, "📊 Toplam kullanıcı: <b>$count</b>", null, true);
}

function sendMessage($chat_id, $text, $keyboard = null, $no_preview = false) {
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard) $data['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
    if ($no_preview) $data['disable_web_page_preview'] = true;
    file_get_contents(API_URL . 'sendMessage?' . http_build_query($data));
}

function sendGifMessage($chat_id, $gif_url, $caption, $inlineKeyboard = null) {
    $data = ['chat_id' => $chat_id, 'animation' => $gif_url, 'caption' => $caption, 'parse_mode' => 'HTML'];
    if ($inlineKeyboard) $data['reply_markup'] = json_encode($inlineKeyboard, JSON_UNESCAPED_UNICODE);
    file_get_contents(API_URL . 'sendAnimation?' . http_build_query($data));
}

function readStateFile() {
    if (!file_exists(STATE_FILE)) return [];
    $json = json_decode(file_get_contents(STATE_FILE), true);
    return is_array($json) ? $json : [];
}

function writeStateFile($data) {
    file_put_contents(STATE_FILE, json_encode($data, JSON_UNESCAPED_UNICODE));
}

function getUserState($chat_id) {
    $all = readStateFile();
    return $all[$chat_id]['state'] ?? 'main';
}

function setUserState($chat_id, $state) {
    $all = readStateFile();
    $all[$chat_id] = ['state' => $state, 'updated_at' => time()];
    writeStateFile($all);
}
?>